//#include "stdafx.h"
#include <windows.h>
#include <mmsystem.h>
//#include <stdio.h>
#include "typedef.h"
#include "Queue.h"
#include "cnComm.h"
#include "uart.h"
#include "Delay.h"
//----------------------------------------
#pragma warning(disable: 4530) 
#pragma warning(disable: 4786) 
#include <cassert> 
#include <iostream> 
#include <vector> 
#include <string> 
#include <exception> 
using namespace std;

//static RingBuffer_t UartRingBuffer;


//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
//uart

class meComm : public CnComm//Զ
{
public:
    unsigned char UartRevRingBuffer[1024];
    RingBuffer_t UartReceiveBuffer;
	BOOL IsTXEmptyFlag;
	meComm()
	{
		UartReceiveBuffer.size=1024;
		UartReceiveBuffer.buffer=UartRevRingBuffer;
		UartReceiveBuffer.Qinit=TRUE;
		UartReceiveBuffer.writeIndex=0;
		UartReceiveBuffer.readIndex=0;
		IsTXEmptyFlag=TRUE;
	}

	~meComm()
	{
		UartReceiveBuffer.size=1024;
		UartReceiveBuffer.buffer=UartRevRingBuffer;
		UartReceiveBuffer.Qinit=TRUE;
		UartReceiveBuffer.writeIndex=0;
		UartReceiveBuffer.readIndex=0;
		IsTXEmptyFlag=TRUE;
	}
protected:
	virtual void OnReceive()
	{
		unsigned char buf[1024];
		unsigned int len;
		len = QueueFreeCount(&UartReceiveBuffer);
		if(len>1024)
			len=1024;
		len = Read(buf,len);
		QueueWrite(&UartReceiveBuffer,buf,len);
	}
	virtual void OnTxEmpty()
	{
		IsTXEmptyFlag=TRUE;
	}
public:
	U8 GetInput(void)
	{
		return QueueDataCount(&UartReceiveBuffer);
	}
	void GetChars(U8 * buffer,U32 len)
	{
		if(buffer==NULL)
			return;
		QueueRead(&UartReceiveBuffer,buffer,len);
	}

	BOOL IsTXEmpty(void)
	{
		BOOL flag;
		flag=IsTXEmptyFlag;
		IsTXEmptyFlag=FALSE;
		return flag;
	}
	
	void Flush(void)
	{
		QueueClear(&UartReceiveBuffer);
	}
	
};
//򿪴 ȱʡ baud_rate, 8, n, 1
//	bool Open(DWORD dwPort, DWORD dwBaudRate)
static meComm Com[255];
//static unsigned char PortIndex;

Bool OpenUart(U8 dwPort,U32 dwBaudRate, U8 Parity, U8 ByteSize, U8 StopBits)//9600, EVENPARITY, 7, ONESTOPBIT
{
	//DCB* meDCB;
	//PortIndex=dwPort;
	if(Com[dwPort].IsOpen())
		Com[dwPort].Close();
	//if(!Com.Open(1,9600))
	if(!Com[dwPort].Open(dwPort, dwBaudRate, Parity, ByteSize, StopBits))
	{
		cout << "COM not open , error : " << GetLastError() << endl;
		return FALSE;
	}
	/*
	//õڲ DCB
	meDCB=Com.GetState();
	meDCB->fDtrControl=DTR_CONTROL_ENABLE;
	meDCB->fRtsControl=RTS_CONTROL_ENABLE;
	//ôڲ DCB
	Com.SetState(meDCB);
	meDCB=Com.GetState();
	Com.SetDTR(true);
	Com.SetRTS(true);
	Sleep(300);
	*/
	return TRUE;
}

U32 GetChars(U8 dwPort,U8 * buffer,U32 len,U32 timeout)
{
	U32 i;
	U32 wait=timeout;//80 * len
	if (buffer == NULL)
		return FALSE;
	if(Com[dwPort].IsOpen()==FALSE)
		return FALSE;
	do
	{
		i = Com[dwPort].GetInput();//û
		//Com.ReadSync(resBuff,4);
		if(i>=len)
		{
			Com[dwPort].GetChars(buffer,len);
			//break;
			return len;
		}
	Delay1Ms(1);
	}while(wait--);
	return 0;
}
U32 SendChars(U8 dwPort,U8 * buffer,U32 len,U32 timeout)
{
	U32 wait=timeout;//1000
	if (buffer == NULL)
		return FALSE;
	if(Com[dwPort].IsOpen()==FALSE)
		return FALSE;
	Com[dwPort].IsTXEmptyFlag=FALSE;
	Com[dwPort].Write(buffer,len);
	do 
	{
		if(Com[dwPort].IsTXEmpty()==TRUE)
			return len;
		Delay1Ms(1);
	} while(wait--);
	return 0;
}

void FlushUart(U8 dwPort)
{
	if(Com[dwPort].IsOpen())
	Com[dwPort].Flush();
}

void CloseUart(unsigned char dwPort)
{
	if(Com[dwPort].IsOpen())
	Com[dwPort].Close();
}
